<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:import href="../../../../commons/constants.xsl"></xsl:import><xsl:import href="../../../../commons/fonctions.xsl"></xsl:import><xsl:import href="../../../../commons/templates.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/BalanceGenerale"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="BalanceGenerale"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR" style="word-wrap:break-word"><div id="header">
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr><td width="75%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p style="margin-bottom:0cm;line-height:normal;punctuation-wrap: simple"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">
                        <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/> – 
                        
                        
                        <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="margin-bottom:0cm;text-align:right; line-height:normal;punctuation-wrap:simple"><span style="font-size:10.0pt; font-family:&#34;Arial&#34;,sans-serif">Date édition : 
                        
                        
                        <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateEdition)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" style="margin-bottom:0cm"><span style="font-size:10.0pt; line-height:115%;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
         <p class="MsoNormal" style="margin-bottom:0cm"><span style="font-size:4.0pt; line-height:115%;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><thead>
               <xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Edition/@TypeEdition = 'P'"><xsl:variable name="varOdm1" select="$docbudg/Budget/LigneBalance"/><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1">
                     <p class="MsoNormal" align="right" style="margin-left:-366.5pt;text-align:right; punctuation-wrap:simple"><xsl:variable name ="Refer34">BALGENCPT</xsl:variable><xsl:variable name ="Refer35" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Refer36" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer34, '_', $Refer35, '_', $Refer36)"/></xsl:call-template>Édition provisoire
                        
                        
                     </p>
                  </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose>
               <xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Edition/@TypeEdition = 'D'"><xsl:variable name="varOdm2" select="$docbudg/Budget/LigneBalance"/><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1">
                     <p class="MsoNormal" align="right" style="margin-left:-366.5pt;text-align:right; punctuation-wrap:simple">Édition définitive</p>
                  </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose>
               <tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center;punctuation-wrap: simple"><b><span style="font-size:12.0pt">BALANCE RÉGLEMENTAIRE DES COMPTES DU GRAND LIVRE</span></b></p>
                  </td></tr>
               <tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p align="center" style="text-align:center;punctuation-wrap: simple">arrêtée à la date du <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateArrete)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></p></td></tr>
               <tr><td width="49%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="50.9%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td></tr>
               <tr><td width="49%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="50.9%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td></tr>
               <tr><td width="49%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p style="punctuation-wrap:simple"><span style="font-size: 8.0pt"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@CodeBC)"/> – <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@Libelle)"/></span></p></td><td width="50.9%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right;punctuation-wrap: simple"><span style="font-size:8.0pt">Exercice : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr>
               <xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BA' or $docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm3" select="$docbudg/Budget/LigneBalance"/><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p style="punctuation-wrap:simple"><span style="font-size: 8.0pt">BA de <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetRattachement/@Libelle)"/></span></p></td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="49%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td><td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose>
            </thead><tr><td width="100%" colspan="2" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0cm 0cm 0cm 0cm" rowspan="1">
                  <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><xsl:variable name="varOdm4" select="$docbudg/Budget/LigneBalance[(./NumOrdre/@V)]"/><thead>
                        <tr height="0" class="#tech# #fixWidths#"><td width="8%" style="border:none" rowspan="1" colspan="1"></td><td width="22%" style="border:none" rowspan="1" colspan="1"></td><td width="7%" style="border:none" rowspan="1" colspan="1"></td><td width="7%" style="border:none" rowspan="1" colspan="1"></td><td width="7%" style="border:none" rowspan="1" colspan="1"></td><td width="7%" style="border:none" rowspan="1" colspan="1"></td><td width="7%" style="border:none" rowspan="1" colspan="1"></td><td width="7%" style="border:none" rowspan="1" colspan="1"></td><td width="7%" style="border:none" rowspan="1" colspan="1"></td><td width="7%" style="border:none" rowspan="1" colspan="1"></td><td width="7%" style="border:none" rowspan="1" colspan="1"></td><td width="7%" style="border:none" rowspan="1" colspan="1"></td></tr>
                        <tr style="height:25.5pt"><td width="8%" rowspan="2" style="border:solid black 1.0pt; border-left:none;padding: 0cm 0cm 1.5pt 0cm;height:25.5pt" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><span style="line-height:115%"><xsl:variable name ="Refer37">BALGENCPT</xsl:variable><xsl:variable name ="Refer38" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Refer39" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer37, '_', $Refer38, '_', $Refer39)"/></xsl:call-template></span><b><span style="font-size:8.0pt;line-height: 115%">Numéro de compte</span></b></p>
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><span style="font-size:8.0pt;line-height:115%"></span></p>
                           </td><td width="22%" rowspan="2" style="border:solid black 1.0pt; border-left:none;padding: 0cm 0cm 1.5pt 0cm;height:25.5pt" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Libellé du compte</span></b></p>
                           </td><td width="14%" colspan="2" style="border:solid black 1.0pt; border-left:none;padding: 0cm 0cm 1.5pt 0cm;height:25.5pt" rowspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Balance d’entrée</span></b></p>
                           </td><td width="14%" colspan="2" style="border:solid black 1.0pt; border-left:none;padding: 0cm 0cm 1.5pt 0cm;height:25.5pt" rowspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Opérations non budgétaires</span></b></p>
                           </td><td width="14%" colspan="2" style="border:solid black 1.0pt; border-left:none;padding: 0cm 0cm 1.5pt 0cm;height:25.5pt" rowspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Opérations budgétaires</span></b></p>
                           </td><td width="14%" colspan="2" style="border:solid black 1.0pt; border-left:none;padding: 0cm 0cm 1.5pt 0cm;height:25.5pt" rowspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Total</span></b></p>
                           </td><td width="14%" colspan="2" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:none; padding: 0cm 0cm 1.5pt 0cm;height:25.5pt" rowspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Soldes</span></b></p>
                           </td></tr>
                        <tr style="height:15.55pt"><td width="7%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Débit</span></b></p>
                           </td><td width="7%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Crédit</span></b></p>
                           </td><td width="7%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Débit</span></b></p>
                           </td><td width="7%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Crédit</span></b></p>
                           </td><td width="7%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Débit</span></b></p>
                           </td><td width="7%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Crédit</span></b></p>
                           </td><td width="7%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Débit</span></b></p>
                           </td><td width="7%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Crédit</span></b></p>
                           </td><td width="7%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Débit</span></b></p>
                           </td><td width="7%" style="border:none;border-bottom:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">Crédit</span></b></p>
                           </td></tr>
                     </thead><xsl:variable name="varOdm5" select="$varOdm4"/><xsl:variable name="varOdm6"><xsl:for-each select="$varOdm5"><xsl:sort select="./NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content92"><xsl:value-of select="distinct-values($ligne/NumCompte/@V)"/></xsl:variable><xsl:variable name="className203" select="$ligne/Format/@V"/><xsl:variable name="className204">LIBELLE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className203, ' ', $className204)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content92" /></xsl:call-template><xsl:variable name="content93"><xsl:value-of select="distinct-values($ligne/LibelleRegl/@V)"/><xsl:value-of select="distinct-values($ligne/LibelleReglCompl/@V)"/></xsl:variable><xsl:variable name="className205" select="$ligne/Format/@V"/><xsl:variable name="className206">LIBELLE</xsl:variable><xsl:variable name="className207">VBORDER</xsl:variable><xsl:variable name="className208">FONT7</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className205, ' ', $className206, ' ', $className207, ' ', $className208)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">22%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content93" /></xsl:call-template><xsl:variable name="content94"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtBalEntreeDeb/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className209" select="$ligne/Format/@V"/><xsl:variable name="className210">DECIMAL</xsl:variable><xsl:variable name="className211">FONT7</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className209, ' ', $className210, ' ', $className211)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content94" /></xsl:call-template><xsl:variable name="content95"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtBalEntreeCre/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className212" select="$ligne/Format/@V"/><xsl:variable name="className213">DECIMAL</xsl:variable><xsl:variable name="className214">FONT7</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className212, ' ', $className213, ' ', $className214)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content95" /></xsl:call-template><xsl:variable name="content96">
                           <span><xsl:variable name ="Link57">LienBalg</xsl:variable><xsl:variable name ="Link58" select="document('../LiensBalance.xml')/comptes" /><xsl:variable name ="Link59" select="$docbudg/EnteteComptable/Infos/Collectivite/@Siret"/><xsl:variable name ="Link60" select="$docbudg/EnteteComptable/Infos/Exercice/@V"/><xsl:variable name ="Link61" select="$ligne/NumCompte/@V"/><xsl:variable name ="Link62">op-non-budg-debit</xsl:variable><xsl:variable name ="Link63">R</xsl:variable><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="$ligne/MtOpeNonBudDeb/@V" /><xsl:with-param name="Param_2" select="$Link57" /><xsl:with-param name="Param_3" select="$Link58" /><xsl:with-param name="Param_4" select="$Link59" /><xsl:with-param name="Param_5" select="$Link60" /><xsl:with-param name="Param_6" select="$Link61" /><xsl:with-param name="Param_7" select="$Link62" /><xsl:with-param name="Param_8" select="$Link63" /></xsl:call-template></span>
                        </xsl:variable><xsl:variable name="className215" select="$ligne/Format/@V"/><xsl:variable name="className216">DECIMAL</xsl:variable><xsl:variable name="className217">FONT7</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className215, ' ', $className216, ' ', $className217)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content96" /></xsl:call-template><xsl:variable name="content97">
                           <span><xsl:variable name ="Link64">LienBalg</xsl:variable><xsl:variable name ="Link65" select="document('../LiensBalance.xml')/comptes" /><xsl:variable name ="Link66" select="$docbudg/EnteteComptable/Infos/Collectivite/@Siret"/><xsl:variable name ="Link67" select="$docbudg/EnteteComptable/Infos/Exercice/@V"/><xsl:variable name ="Link68" select="$ligne/NumCompte/@V"/><xsl:variable name ="Link69">op-non-budg-credit</xsl:variable><xsl:variable name ="Link70">D</xsl:variable><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="$ligne/MtOpeNonBudCre/@V" /><xsl:with-param name="Param_2" select="$Link64" /><xsl:with-param name="Param_3" select="$Link65" /><xsl:with-param name="Param_4" select="$Link66" /><xsl:with-param name="Param_5" select="$Link67" /><xsl:with-param name="Param_6" select="$Link68" /><xsl:with-param name="Param_7" select="$Link69" /><xsl:with-param name="Param_8" select="$Link70" /></xsl:call-template></span>
                        </xsl:variable><xsl:variable name="className218" select="$ligne/Format/@V"/><xsl:variable name="className219">DECIMAL</xsl:variable><xsl:variable name="className220">FONT7</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className218, ' ', $className219, ' ', $className220)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content97" /></xsl:call-template><xsl:variable name="content98">
                           <span><xsl:variable name ="Link71">LienBalg</xsl:variable><xsl:variable name ="Link72" select="document('../LiensBalance.xml')/comptes" /><xsl:variable name ="Link73" select="$docbudg/EnteteComptable/Infos/Collectivite/@Siret"/><xsl:variable name ="Link74" select="$docbudg/EnteteComptable/Infos/Exercice/@V"/><xsl:variable name ="Link75" select="$ligne/NumCompte/@V"/><xsl:variable name ="Link76">op-budg-debit</xsl:variable><xsl:variable name ="Link77">R</xsl:variable><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="$ligne/MtOpeBudDeb/@V" /><xsl:with-param name="Param_2" select="$Link71" /><xsl:with-param name="Param_3" select="$Link72" /><xsl:with-param name="Param_4" select="$Link73" /><xsl:with-param name="Param_5" select="$Link74" /><xsl:with-param name="Param_6" select="$Link75" /><xsl:with-param name="Param_7" select="$Link76" /><xsl:with-param name="Param_8" select="$Link77" /></xsl:call-template></span>
                        </xsl:variable><xsl:variable name="className221" select="$ligne/Format/@V"/><xsl:variable name="className222">DECIMAL</xsl:variable><xsl:variable name="className223">FONT7</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className221, ' ', $className222, ' ', $className223)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content98" /></xsl:call-template><xsl:variable name="content99">
                           <span><xsl:variable name ="Link78">LienBalg</xsl:variable><xsl:variable name ="Link79" select="document('../LiensBalance.xml')/comptes" /><xsl:variable name ="Link80" select="$docbudg/EnteteComptable/Infos/Collectivite/@Siret"/><xsl:variable name ="Link81" select="$docbudg/EnteteComptable/Infos/Exercice/@V"/><xsl:variable name ="Link82" select="$ligne/NumCompte/@V"/><xsl:variable name ="Link83">op-budg-credit</xsl:variable><xsl:variable name ="Link84">D</xsl:variable><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="$ligne/MtOpeBudCre/@V" /><xsl:with-param name="Param_2" select="$Link78" /><xsl:with-param name="Param_3" select="$Link79" /><xsl:with-param name="Param_4" select="$Link80" /><xsl:with-param name="Param_5" select="$Link81" /><xsl:with-param name="Param_6" select="$Link82" /><xsl:with-param name="Param_7" select="$Link83" /><xsl:with-param name="Param_8" select="$Link84" /></xsl:call-template></span>
                        </xsl:variable><xsl:variable name="className224" select="$ligne/Format/@V"/><xsl:variable name="className225">DECIMAL</xsl:variable><xsl:variable name="className226">FONT7</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className224, ' ', $className225, ' ', $className226)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content99" /></xsl:call-template><xsl:variable name="content100">
                           <span><xsl:variable name ="Link85">LienBalg</xsl:variable><xsl:variable name ="Link86" select="document('../LiensBalance.xml')/comptes" /><xsl:variable name ="Link87" select="$docbudg/EnteteComptable/Infos/Collectivite/@Siret"/><xsl:variable name ="Link88" select="$docbudg/EnteteComptable/Infos/Exercice/@V"/><xsl:variable name ="Link89" select="$ligne/NumCompte/@V"/><xsl:variable name ="Link90">tot-debit</xsl:variable><xsl:variable name ="Link91">R</xsl:variable><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="$ligne/MtTotDeb/@V" /><xsl:with-param name="Param_2" select="$Link85" /><xsl:with-param name="Param_3" select="$Link86" /><xsl:with-param name="Param_4" select="$Link87" /><xsl:with-param name="Param_5" select="$Link88" /><xsl:with-param name="Param_6" select="$Link89" /><xsl:with-param name="Param_7" select="$Link90" /><xsl:with-param name="Param_8" select="$Link91" /></xsl:call-template></span>
                        </xsl:variable><xsl:variable name="className227" select="$ligne/Format/@V"/><xsl:variable name="className228">DECIMAL</xsl:variable><xsl:variable name="className229">FONT7</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className227, ' ', $className228, ' ', $className229)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content100" /></xsl:call-template><xsl:variable name="content101">
                           <span><xsl:variable name ="Link92">LienBalg</xsl:variable><xsl:variable name ="Link93" select="document('../LiensBalance.xml')/comptes" /><xsl:variable name ="Link94" select="$docbudg/EnteteComptable/Infos/Collectivite/@Siret"/><xsl:variable name ="Link95" select="$docbudg/EnteteComptable/Infos/Exercice/@V"/><xsl:variable name ="Link96" select="$ligne/NumCompte/@V"/><xsl:variable name ="Link97">tot-credit</xsl:variable><xsl:variable name ="Link98">D</xsl:variable><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="$ligne/MtTotCre/@V" /><xsl:with-param name="Param_2" select="$Link92" /><xsl:with-param name="Param_3" select="$Link93" /><xsl:with-param name="Param_4" select="$Link94" /><xsl:with-param name="Param_5" select="$Link95" /><xsl:with-param name="Param_6" select="$Link96" /><xsl:with-param name="Param_7" select="$Link97" /><xsl:with-param name="Param_8" select="$Link98" /></xsl:call-template></span>
                        </xsl:variable><xsl:variable name="className230" select="$ligne/Format/@V"/><xsl:variable name="className231">DECIMAL</xsl:variable><xsl:variable name="className232">FONT7</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className230, ' ', $className231, ' ', $className232)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content101" /></xsl:call-template><xsl:variable name="content102">
                           <span><xsl:variable name ="Link99">LienBalg</xsl:variable><xsl:variable name ="Link100" select="document('../LiensBalance.xml')/comptes" /><xsl:variable name ="Link101" select="$docbudg/EnteteComptable/Infos/Collectivite/@Siret"/><xsl:variable name ="Link102" select="$docbudg/EnteteComptable/Infos/Exercice/@V"/><xsl:variable name ="Link103" select="$ligne/NumCompte/@V"/><xsl:variable name ="Link104">solde-debit</xsl:variable><xsl:variable name ="Link105">R</xsl:variable><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="$ligne/MtSoldeDeb/@V" /><xsl:with-param name="Param_2" select="$Link99" /><xsl:with-param name="Param_3" select="$Link100" /><xsl:with-param name="Param_4" select="$Link101" /><xsl:with-param name="Param_5" select="$Link102" /><xsl:with-param name="Param_6" select="$Link103" /><xsl:with-param name="Param_7" select="$Link104" /><xsl:with-param name="Param_8" select="$Link105" /></xsl:call-template></span>
                        </xsl:variable><xsl:variable name="className233" select="$ligne/Format/@V"/><xsl:variable name="className234">DECIMAL</xsl:variable><xsl:variable name="className235">FONT7</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className233, ' ', $className234, ' ', $className235)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content102" /></xsl:call-template><xsl:variable name="content103">
                           <span><xsl:variable name ="Link106">LienBalg</xsl:variable><xsl:variable name ="Link107" select="document('../LiensBalance.xml')/comptes" /><xsl:variable name ="Link108" select="$docbudg/EnteteComptable/Infos/Collectivite/@Siret"/><xsl:variable name ="Link109" select="$docbudg/EnteteComptable/Infos/Exercice/@V"/><xsl:variable name ="Link110" select="$ligne/NumCompte/@V"/><xsl:variable name ="Link111">solde-credit</xsl:variable><xsl:variable name ="Link112">D</xsl:variable><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="$ligne/MtSoldeCre/@V" /><xsl:with-param name="Param_2" select="$Link106" /><xsl:with-param name="Param_3" select="$Link107" /><xsl:with-param name="Param_4" select="$Link108" /><xsl:with-param name="Param_5" select="$Link109" /><xsl:with-param name="Param_6" select="$Link110" /><xsl:with-param name="Param_7" select="$Link111" /><xsl:with-param name="Param_8" select="$Link112" /></xsl:call-template></span>
                        </xsl:variable><xsl:variable name="className236" select="$ligne/Format/@V"/><xsl:variable name="className237">DECIMAL</xsl:variable><xsl:variable name="className238">FONT7</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className236, ' ', $className237, ' ', $className238)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content103" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm7"><xsl:choose><xsl:when test="count($varOdm6/*) = 0"><tr class=" #tech#" style="height:15.55pt"><td height="1px" width="7%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="border-bottom:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm; border-top:hidden; border-left:none; border-right:none"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm6"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm7/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
                  <xsl:variable name="varOdmTmpTab4"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr><xsl:variable name="varOdm8" select="$docbudg/Budget/LigneBalance"/><td width="100%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p style="punctuation-wrap:simple"><xsl:if test="not($varOdm8/NumOrdre/@V)">Cet état ne contient pas d'information.</xsl:if></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param></xsl:call-template>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
         <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size:4.0pt"> </span></p>
         <p class="MsoNormal"> </p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>